# LinkedIn Sales Navigator Scraper

This documentation will guide you through setting up and using the LinkedIn Sales Navigator Scraper workflow to generate and enrich leads automatically.

## Overview

The LinkedIn Sales Navigator Scraper is a set of n8n workflows that allows you to:

- Scrape leads from LinkedIn Sales Navigator search results
- Store the leads in a Supabase database
- Enrich the leads with email addresses and additional data
- Automate your lead generation and enrichment process

## Prerequisites

Before you can use the LinkedIn Sales Navigator Scraper, you'll need:

- An n8n instance (self-hosted or cloud)
- A LinkedIn Sales Navigator account
- An Apify account (for the scraper)
- A Supabase account (for the database)
- An Apollo.io account (for lead enrichment)

## Getting Started

1. Follow the setup guide to configure your environment
2. Import the workflows into n8n
3. Configure your credentials
4. Run your first scrape

## Documentation

- [Setup Guide](docs/setup.md)
- [Lead Generation Workflow](docs/lead-generation.md)
- [Lead Enrichment Workflow](docs/lead-enrichment.md)
- [FAQ](docs/faq.md)

## License

This project is licensed under the MIT License - see the LICENSE file for details.

