# Frequently Asked Questions

## General Questions

### What is the LinkedIn Sales Navigator Scraper?

The LinkedIn Sales Navigator Scraper is a set of n8n workflows that allows you to automate lead generation and enrichment by scraping LinkedIn Sales Navigator search results and enriching the leads with email addresses and additional data.

### Is this legal to use?

Web scraping exists in a legal gray area. While it's not illegal per se, it may violate LinkedIn's Terms of Service. Use this tool at your own risk and for educational purposes only. We recommend:

1. Respecting rate limits
2. Not scraping sensitive personal information
3. Using the data in compliance with privacy laws like GDPR and CCPA

### What technologies are used in this project?

- n8n for workflow automation
- Apify for web scraping
- Apollo.io for lead enrichment
- Supabase for database storage
- Next.js and Tailwind for documentation

## Setup Questions

### How do I get my LinkedIn cookie?

1. Log in to LinkedIn Sales Navigator
2. Open your browser's developer tools (F12)
3. Go to the "Application" tab
4. Under "Storage", select "Cookies" and then the LinkedIn domain
5. Copy all cookies and format them as a JSON object

### How many leads can I scrape?

The number of leads you can scrape depends on:

1. Your LinkedIn Sales Navigator account type
2. Apify's rate limits
3. Apollo.io's API limits

With a standard setup, you can typically scrape and enrich a few hundred leads per day.

### How much does this cost to run?

The costs associated with running these workflows include:

1. LinkedIn Sales Navigator subscription (starting at $99/month)
2. Apify costs (pay-as-you-go or subscription)
3. Apollo.io subscription (various tiers available)
4. n8n hosting (self-hosted or cloud)
5. Supabase hosting (free tier available)

## Troubleshooting

### The workflow fails when retrieving the dataset

This usually happens when the Apify scraper is still running. The workflow includes a wait node that will retry after a few minutes. If it continues to fail:

1. Check the Apify console to see if the scraper is still running
2. Verify that your Apify API key is correct
3. Increase the wait time in the Wait node

### The lead enrichment is not finding email addresses

Apollo.io's ability to find email addresses depends on various factors:

1. The completeness of the lead's LinkedIn profile
2. The availability of the company's email pattern
3. Your Apollo.io subscription tier

Try enriching leads from larger, more established companies for better results.

### How do I update the workflows?

To update the workflows:

1. Download the latest workflow files from this documentation
2. In n8n, go to the workflow you want to update
3. Click on the three dots in the top right corner
4. Select "Import from File"
5. Choose the downloaded workflow file
6. Confirm the import

## Advanced Usage

### Can I customize the workflows?

Yes, you can customize the workflows in n8n to:

1. Add additional data processing steps
2. Integrate with other tools (CRM, email marketing, etc.)
3. Modify the scraping parameters
4. Change the enrichment process

### How do I schedule the workflows to run automatically?

In n8n, you can:

1. Replace the form trigger with a schedule trigger
2. Set the frequency (daily, weekly, etc.)
3. Configure the workflow to run automatically

Note that you'll need to hardcode the LinkedIn cookie, search URL, and API keys if you use a schedule trigger.

### Can I export the leads to other systems?

Yes, you can add nodes to the workflows to export the leads to:

1. CRM systems (Salesforce, HubSpot, etc.)
2. Email marketing platforms (Mailchimp, SendGrid, etc.)
3. Spreadsheets (Google Sheets, Excel, etc.)
4. Other databases or applications

