# Lead Enrichment Workflow

The Lead Enrichment workflow enriches your leads with email addresses and additional data using the Apollo.io API.

## Workflow Overview

This workflow performs the following steps:

1. Retrieves unenriched leads from your Supabase database
2. Processes the leads in batches
3. Calls the Apollo.io API to enrich the leads with email addresses and additional data
4. Updates the leads in your Supabase database with the enriched data

## Prerequisites

Before setting up the Lead Enrichment workflow, you'll need:

- An Apollo.io account and API key
- A Supabase account and database (same as for Lead Generation)
- The Lead Generation workflow set up and running

## Setup Instructions

### 1. Download and Import the Workflow

First, download the Lead Enrichment workflow file and import it into your n8n instance.

### 2. Configure Your Credentials

In n8n, configure the following credentials:

- Supabase API credentials (same as for Lead Generation)
- Update the Apollo.io API key in the HTTP Request node

### 3. Run the Workflow

The Lead Enrichment workflow can be run in two ways:

1. Automatically triggered by the Lead Generation workflow
2. Manually triggered using the "When clicking 'Test workflow'" trigger

## Workflow Nodes Explanation

### Manual Trigger

This node allows you to manually trigger the workflow for testing or one-time runs.

### Supabase1

Retrieves unenriched leads from your Supabase database (where enriched = FALSE).

### Loop Over Items

Processes the leads in batches to avoid overwhelming the Apollo.io API.

### Edit Fields

Prepares the lead data for the Apollo.io API by formatting it according to the API requirements.

### Aggregate

Aggregates the lead data into a single request for the Apollo.io API.

### HTTP Request

Calls the Apollo.io API to enrich the leads with email addresses and additional data.

### Code1

Processes the response from the Apollo.io API and matches it with the original lead data.

### Supabase2

Updates the leads in your Supabase database with the enriched data, including email addresses and additional information.

## Apollo.io API Integration

The workflow uses the Apollo.io API to enrich your leads with email addresses and additional data. The API provides:

- Email addresses (personal and work)
- Phone numbers
- Social media profiles
- Company information
- Job history

## Next Steps

After setting up both workflows, you can:

1. Schedule the Lead Generation workflow to run periodically
2. Export the enriched leads from your Supabase database
3. Use the leads in your CRM or marketing automation platform

