# Lead Generation Workflow

The Lead Generation workflow scrapes LinkedIn Sales Navigator search results and stores them in your Supabase database.

## Workflow Overview

This workflow performs the following steps:

1. Collects LinkedIn Sales Navigator search URL, cookie, and Apify API key via a form
2. Triggers the Apify LinkedIn Sales Navigator Scraper
3. Retrieves the scraped data from Apify
4. Processes and stores the leads in your Supabase database
5. Triggers the Lead Enrichment workflow to enrich the leads with email addresses

## Prerequisites

Before setting up the Lead Generation workflow, you'll need:

- An Apify account and API key
- A LinkedIn Sales Navigator account
- Your LinkedIn cookie in JSON format
- A Supabase account and database

## Setup Instructions

### 1. Download and Import the Workflow

First, download the Lead Generation workflow file and import it into your n8n instance.

### 2. Set Up Your Supabase Database

Create a table in your Supabase database with the following structure:

| Column Name | Type | Description |
|-------------|------|-------------|
| id | uuid | Primary key |
| first_name | text | First name of the lead |
| last_name | text | Last name of the lead |
| job_title | text | Job title of the lead |
| company | text | Company name |
| company_industry | text | Industry of the company |
| location | text | Location of the lead |
| linkendInUrl | text | LinkedIn profile URL |
| email | text | Email address (will be filled by enrichment) |
| enriched | boolean | Whether the lead has been enriched |
| enrichment_data | json | Additional enrichment data |

### 3. Configure Your Credentials

In n8n, configure the following credentials:

- Supabase API credentials

### 4. Get Your LinkedIn Cookie

To get your LinkedIn cookie in JSON format:

1. Log in to LinkedIn Sales Navigator
2. Open your browser's developer tools (F12)
3. Go to the "Application" tab
4. Under "Storage", select "Cookies" and then the LinkedIn domain
5. Copy all cookies and format them as a JSON object

### 5. Run the Workflow

To run the Lead Generation workflow:

1. Activate the workflow in n8n
2. Access the form URL provided by n8n
3. Fill in the form with your LinkedIn cookie, search URL, and Apify API key
4. Submit the form to start the scraping process

## Workflow Nodes Explanation

### Form Trigger

This node creates a form that collects:

- LinkedIn Cookie (in JSON format)
- LinkedIn Sales Navigator search URL
- Apify API key

### Code Node

Processes the form data and prepares it for the Apify scraper.

### LinkedIn Sales Nav Scraper

Calls the Apify API to start the LinkedIn Sales Navigator scraper with the provided parameters.

### Retrieve Dataset

Retrieves the scraped data from Apify once the scraping is complete.

### Verify Dataset Availability

Checks if the dataset is available and ready for processing.

### If Node

Determines whether to process the data or wait for the dataset to be ready.

### Wait

Waits for a specified time before checking the dataset availability again.

### Supabase

Stores the scraped lead data in your Supabase database.

### Execute Workflow

Triggers the Lead Enrichment workflow to enrich the leads with email addresses.

## Next Steps

After setting up the Lead Generation workflow, proceed to the Lead Enrichment workflow to enrich your leads with email addresses and additional data.

