# Setup Guide

This guide will walk you through setting up the LinkedIn Sales Navigator Scraper workflows.

## Prerequisites

Before you begin, make sure you have:

1. An n8n instance (self-hosted or cloud)
2. A LinkedIn Sales Navigator account
3. An Apify account
4. A Supabase account
5. An Apollo.io account

## Step 1: Set Up Supabase

1. Create a new project in Supabase
2. Create a new table called `simple_leads` with the following columns:

| Column Name | Type | Description |
|-------------|------|-------------|
| id | uuid | Primary key |
| first_name | text | First name of the lead |
| last_name | text | Last name of the lead |
| job_title | text | Job title of the lead |
| company | text | Company name |
| company_industry | text | Industry of the company |
| location | text | Location of the lead |
| linkendInUrl | text | LinkedIn profile URL |
| email | text | Email address (will be filled by enrichment) |
| enriched | boolean | Whether the lead has been enriched |
| enrichment_data | json | Additional enrichment data |

3. Get your Supabase API URL and API Key from the project settings

## Step 2: Set Up Apify

1. Create an account on Apify.com
2. Go to Account Settings > Integrations
3. Copy your API Key

## Step 3: Set Up Apollo.io

1. Create an account on Apollo.io
2. Go to Settings > API
3. Generate and copy your API Key

## Step 4: Import Workflows into n8n

1. Download the workflow files from this documentation
2. Open your n8n instance
3. Go to Workflows
4. Click "Import from File"
5. Select the downloaded workflow files
6. Import both the Lead Generation and Lead Enrichment workflows

## Step 5: Configure Credentials in n8n

1. In n8n, go to Settings > Credentials
2. Add your Supabase credentials
3. Update the Apollo.io API key in the HTTP Request node of the Lead Enrichment workflow
4. Update the Apify API key placeholder in the Lead Generation workflow

## Step 6: Get Your LinkedIn Cookie

1. Log in to LinkedIn Sales Navigator
2. Open your browser's developer tools (F12)
3. Go to the Application tab
4. Under Storage, select Cookies and then the LinkedIn domain
5. Copy all cookies and format them as a JSON object

## Step 7: Activate and Run the Workflows

1. Activate both workflows in n8n
2. Access the form URL provided by the Lead Generation workflow
3. Fill in the form with your LinkedIn cookie, search URL, and Apify API key
4. Submit the form to start the scraping process

## Troubleshooting

### Common Issues

1. **LinkedIn Cookie Format**: Make sure your LinkedIn cookie is properly formatted as a JSON object
2. **API Keys**: Double-check that all API keys are correctly entered
3. **Supabase Table Structure**: Ensure your Supabase table has all the required columns
4. **n8n Connections**: Verify that all node connections in the workflows are intact

### Getting Help

If you encounter issues with the workflows, check the following resources:

1. n8n documentation: https://docs.n8n.io/
2. Apify documentation: https://docs.apify.com/
3. Apollo.io API documentation: https://apolloio.github.io/apollo-api-docs/
4. Supabase documentation: https://supabase.com/docs

